
clear
run AttyFee2007Definitions.do

log using 06Components.smcl, replace

/// Table 6.1: Predictive models duplicating Predictive Model from Ch 3
reg lnfeeexpord lnassets prepack preneg lnsales xyearfiled  shop [pw=pweight], vce(robust)
outreg2 using "table6_1.rtf", replace ///
	label ctitle("FeeExpOrd", "(log)") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2) ///
	title("Table 6.1","Prediction of Fee and Expense Components","Using Aggregate Models") 
reg lnattyfeeexpord lnassets prepack preneg lnsales xyearfiled  shop [pw=pweight], vce(robust)
outreg2 using "table6_1.rtf", append ///
	label ctitle("AttyFee-", "ExpOrd","(log)") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2) 
reg lnfafeeexpord1 lnassets prepack preneg lnsales xyearfiled  shop [pw=pweight], vce(robust)
outreg2 using "table6_1.rtf", append ///
	label ctitle("FaFee-", "ExpOrd","(log)") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2) 
reg lndipbkattyfeeexpord lnassets prepack preneg lnsales xyearfiled  shop [pw=pweight], vce(robust)
outreg2 using "table6_1.rtf", append ///
	label ctitle("DipBkAtty","FeeExpOrd","(log)") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2) 
reg lndipfafeeexpord1 lnassets prepack preneg lnsales xyearfiled  shop [pw=pweight], vce(robust)
outreg2 using "table6_1.rtf", append ///
	label ctitle("DipFa-","FeeExpOrd","(log)") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2) 
reg lndipspecattyfeeexpord1 lnassets prepack preneg lnsales xyearfiled  shop [pw=pweight], vce(robust)
outreg2 using "table6_1.rtf", append ///
	label ctitle("DipSpecAtty-","FeeExpOrd","(log)") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2) 


/// Table 6.2: Evaluative Model duplicating Evaluative Model from Ch 3
reg  lnfeeexpord lnassets lndaysin yearconfirmed saleall lnemployees shop lnroles [pw=pweight], vce(robust)
outreg2 using "table6_2.rtf", replace /// 
	 label ctitle("FeeExpOrd","(log)") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2) ///
	title("Table 6.2","Evaluation of Fee and Expense Components","Using Aggregate Models") 
reg  lnattyfeeexpord lnroleatty  lnassets lndaysin yearconfirmed saleall lnemployees shop [pw=pweight], vce(robust)
outreg2 using "table6_2.rtf", append /// 
	 label ctitle("AttyFee-","ExpOrd","(log)") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2) 
reg  lnfafeeexpord1 lnrolefa1  lnassets lndaysin yearconfirmed saleall lnemployees shop [pw=pweight], vce(robust)
outreg2 using "table6_2.rtf", append /// 
	label ctitle("FaFee-","ExpOrd","(log)") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2) 
reg  lndipbkattyfeeexpord lnroledipbkatty  lnassets lndaysin yearconfirmed saleall lnemployees shop [pw=pweight], vce(robust)
outreg2 using "table6_2.rtf", append /// 
	label ctitle("DipBkAtty-","FeeExpOrd","(log)") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2) 
reg  lndipfafeeexpord1 lnroledipfa1  lnassets lndaysin yearconfirmed saleall lnemployees shop [pw=pweight], vce(robust)
outreg2 using "table6_2.rtf", append /// 
	label ctitle("DipFa-","FeeExpOrd","(log)") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2) 
reg  lndipspecattyfeeexpord1 lnroledipspecatty1  lnassets lndaysin yearconfirmed saleall lnemployees shop [pw=pweight], vce(robust)
outreg2 using "table6_2.rtf", append /// 
	label ctitle("DipSpecAtty-","FeeExpOrd","(log)") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2) 

///  Table 6.3  DIP Bankruptcy Attorneys' Fees and Expenses, by Type

///  Table 6.4
/// Chow test for predictive model
foreach x in indu judges attyfirms {
	reg  lndipbkattyfeeexpord lnassets prepack preneg xyearfiled shop dedist $`x'[pw=pweight], vce(robust)
	test $`x'
	}
reg  lndipbkattyfeeexpord lnassets prepack preneg xyearfiled shop telecom dedist [pw=pweight], vce(robust)
outreg2 using "table6_4.rtf", replace ///
	label ctitle("DipBkAtty-","FeeExpOrd","(log)","Predictive") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2) ///
	title("Table 6.4","Determinants of DIP Bankruptcy Attorneys Fees and Expenses") 
/// Which measure of size is best?  
foreach x in lnsales lnassets lnemployees lnliabilities {
	reg lndipbkattyfeeexpord `x' yearconfirmed lnroledipbkatty lndaysin lnexperience  [pw=pweight], vce(robust)
	}
reg lndipbkattyfeeexpord lnassets yearconfirmed lnroledipbkatty lndaysin lnexperience  [pw=pweight], vce(robust)
outreg2 using "table6_4.rtf", append ///
	label ctitle("DipBkAtty-","FeeExpOrd","(log)","Evaluative") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2)  
/// reg lndipbkattyfeeexpord lnassets telecom lndaysin yearconfirmed rothschild distnum emerge1  NY miller lazard lnexperience [pw=pweight], vce(robust)
reg lndipbkattyfeeexpord lnassets yearconfirmed lnroledipbkatty lndaysin lnexperience lazard rothschild  [pw=pweight], vce(robust)
outreg2 using "table6_4.rtf", append ///
	label ctitle("DipBkAtty-","FeeExpOrd","(log)","Evaluative") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2)  
reg lndipbkattyfeeexpord lnassets yearconfirmed  lndaysin lndocket lnexperience lazard rothschild NY NYdocket [pw=pweight], vce(robust)
outreg2 using "table6_4.rtf", append ///
	label ctitle("DipBkAtty-","FeeExpOrd","(log)","Evaluative") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2)  

///  Table 6.4 distnum entered to model 2, removing roles.
///  Distnum is correlated with roles, and either could be driving fees.
///  Finding is that local DIP lead BK attys are cheaper, when it's local there are fewer of them.
reg lndipbkattyfeeexpord lnassets yearconfirmed lndaysin distnum lazard rothschild [pw=pweight], vce(robust)	
	
/// Table 6.4 negative findings
foreach x of varlist nyfirm dipfafeeexpord roledipfa saleall emerge1 liquidation  {
reg lndipbkattyfeeexpord lnassets yearconfirmed lnroledipbkatty lndaysin distnum `x' [pw=pweight], vce(robust)
	}

///  Table 6.4.a
reg lndipleadbkattyfeeexpordbef lndaysbef ernst transequip lnassets lnexperience yearconfirmed lifland equity [pw=pweight], vce(robust)
/// outreg2 using "S:\FacStaff\Faculty\LoPucki-RA\ProfessionalFeesBook\Stata\05Components\table6_4_a.rtf", replace alpha(0.001, 0.01, 0.05) title("Table 6.4.a","Predictors of Pre- and Post-petition DIP Lead Bankruptcy Attorneys Fees","in Large, Public Company Bankruptcies") adjr2 bdec(3) rdec(2)
reg lndipleadbkattyfeeexpordall lnassets yearconfirmed feecom walrath liquidation manufacturing ernst lndaysall [pw=pweight], vce(robust)
reg dipleadbkattyfeeexpordbefpct lndaysin  [pw=pweight], vce(robust)
reg dipleadbkattyfeeexpordbefpct lnassets lndaysin lndaysbef andrews emerge1 retail creditinstitution houlihan [pw=pweight], vce(robust)

///  Table 6.5.
reg lndipspecattyfeeexpord1 lnassets  prepackneg   telecom distnum solvency [pw=pweight], vce(robust)
outreg2 using "table6_5.rtf", replace ///
	label ctitle("DipSpecAtty-","FeeExpOrd","(log)","Predictive") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2) ///
	title("Table 6.5","Determinants of DIP Special Counsel Fees and Expenses") 
foreach x in judges attyfirms fafirms {
reg lndipspecattyfeeexpord1 lnassets  prepackneg distnum solvency $`x' [pw=pweight], vce(robust)
test $`x'
}
reg lndipspecattyfeeexpord1 lnassets  prepackneg  telecom  distnum  ernst rothschild gonzalez  solvency lnexperience [pw=pweight], vce(robust)
outreg2 using "table6_5.rtf", append ///
	label ctitle("DipSpecAtty-","FeeExpOrd","(log)","Predictive") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2) 
reg lndipspecattyfeeexpord1  lnroledipspecatty1  weil prepackneg  lifland  solvency lnplanclasses [pw=pweight], vce(robust)
outreg2 using "table6_5.rtf", append ///
	label ctitle("DipSpecAtty-","FeeExpOrd","(log)","Evaluative") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2) 
reg lndipspecattyfeeexpord1  lnroledipspecatty1  roledipspeczero [pw=pweight], vce(robust)
outreg2 using "table6_5.rtf", append ///
	label ctitle("DipSpecAtty-","FeeExpOrd","(log)","Evaluative") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2) 

///  Table 6.6.
reg lnroledipspecatty1 lnassets distnum prepack preneg telecom skadden [pw=pweight], vce(robust)
outreg2 using table6_6.rtf, replace /// 
	label  ctitle("RoleDip-","SpecAtty","(log)","Predictive") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2) ///
	title("Table 6.6","Determinants of the Number of DIP Special Counsel Working") 
foreach x in indu judges attyfirms fafirms leadbkfirms {
reg lnroledipspecatty1 lnassets distnum prepack preneg $`x' [pw=pweight], vce(robust)
test $`x'
}
reg lnroledipspecatty1 lnassets lndaysin distnum [pw=pweight], vce(robust)
outreg2 using table6_6.rtf, append /// 
	label  ctitle("RoleDip-","SpecAtty","(log)","Evaluative") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2) 
foreach x in indu judges attyfirms fafirms {
reg lnroledipspecatty1 lnassets lndaysin distnum $`x' [pw=pweight], vce(robust)
test $`x'
}
reg lnroledipspecatty1 lnassets lndaysin distnum skadden [pw=pweight], vce(robust)
outreg2 using table6_6.rtf, append /// 
	label ctitle("RoleDip-","SpecAtty","(log)","Evaluative") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2) 


///  Table 6.7.
reg lnattyfeeexpord lnassets prepack preneg shop dedist [pw=pweight], vce(robust)
outreg2 using table6_7.rtf, replace /// 
	label  ctitle ("AttyFee-","ExpOrd","(log)","Predictive") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2) /// 
	title("Table 6.7","Determinants of Attorney Fees and Expenses") 
foreach x in indu judges attyfirms fafirms {
reg lnattyfeeexpord lnassets prepack preneg shop dedist $`x' [pw=pweight], vce(robust)
test $`x'
}
reg lnattyfeeexpord lnassets prepack preneg shop dedist telecom houlihan miller [pw=pweight], vce(robust)
outreg2 using table6_7.rtf, append /// 
	label  ctitle ("AttyFee-","ExpOrd","(log)","Predictive") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2) 
reg lnattyfeeexpord lnassets lndaysin yearconfirmed lnroleatty lnemployees feecom [pw=pweight], vce(robust)
outreg2 using table6_7.rtf, append /// 
	label  ctitle ("AttyFee-","ExpOrd","(log)","Evaluative") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2) 
foreach x in indu judges attyfirms fafirms {
reg lnattyfeeexpord  lnassets lndaysin yearconfirmed lnroleatty lnemployees feecom $`x' [pw=pweight], vce(robust)
test $`x'
	}
reg lnattyfeeexpord  lnassets lndaysin yearconfirmed lnroleatty lnemployees feecom creditinstitution emerge1 [pw=pweight], vce(robust)
outreg2 using table6_7.rtf, append /// 
	label  ctitle ("AttyFee-","ExpOrd","(log)","Evaluative") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2) 



///  Table 6.8.
reg lndipfafeeexpord1 lnassets lnsales DE  xyearfiled [pw=pweight] if lndipfafeeexpord1>0, vce(robust)
outreg2 using table6_8.rtf, replace /// 
	label  ctitle ("DipFa-","FeeExpOrd","(log)","Predictive") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2) /// 
	title("Table 6.8","Determinants of DIP Financial Advisor Fees and Expenses") 
foreach x in indu judges leadbkfirms fafirms {
	reg lndipfafeeexpord1 lnassets lnsales DE  xyearfiled $`x' [pw=pweight] if lndipfafeeexpord1>0, vce(robust)
test $`x'
	}
reg lndipfafeeexpord1 lnassets lnsales DE  xyearfiled  blackstone  houlihan willkie [pw=pweight] if lndipfafeeexpord1>0, vce(robust)
outreg2 using table6_8.rtf, append /// 
	label  ctitle ("DipFa-","FeeExpOrd","(log)","Predictive") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2) 
reg lndipfafeeexpord1 lnroledipfa1 [pw=pweight] if lndipfafeeexpord1>0, vce(robust)
outreg2 using table6_8.rtf, append /// 
	label  ctitle ("DipFa-","FeeExpOrd","(log)","Evaluative") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2) 
foreach x in indu judges attyfirms fafirms {
	reg lndipfafeeexpord1 lnroledipfa1 lnassets lnsales DE yearconfirmed  $`x' [pw=pweight] if lndipfafeeexpord1>0, vce(robust)
test $`x'
	}
reg lndipfafeeexpord1 lnroledipfa1 lnassets lnsales DE yearconfirmed weil willkie blackstone  houlihan rothschild [pw=pweight] if lndipfafeeexpord1>0, vce(robust)
outreg2 using table6_8.rtf, append  /// 
	label  ctitle ("DipFa-","FeeExpOrd","(log)","Evaluative") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2) 

	
	
/// Table 6.9   Financial Advisors Fees and Expenses, by Client Category

///  Table 6.10.
/// reg lnfafeeexpord1 lnemployees houlihan equity willkie blackstone xyearfiled lifland finance distnum  lnexperience DE [pw=pweight], vce(robust)
reg lnfafeeexpord1 lnassets lnsales xyearfiled [pw=pweight] if roledipfa>0, vce(robust)
outreg2 using table6_10.rtf, replace ///
	label  ctitle ("FaFee-","ExpOrd","(log)","Predictive") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2) /// 
	title("Table 6.10","Determinants of Financial Advisor Fees and Expenses") 
foreach x in indu judges attyfirms fafirms {
	reg lnfafeeexpord1 lnassets lnsales xyearfiled $`x' [pw=pweight] if roledipfa>0, vce(robust)
	test $`x'
		}
reg lnfafeeexpord1 lnassets lnsales xyearfiled blackstone  houlihan [pw=pweight] if roledipfa>0, vce(robust)
outreg2 using table6_10.rtf, append ///
	label  ctitle ("FaFee-","ExpOrd","(log)","Predictive") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2) 
reg lnfafeeexpord1 lnrolefa1 [pw=pweight] if roledipfa>0, vce(robust)
outreg2 using table6_10.rtf, append ///
	label  ctitle ("FaFee-","ExpOrd","(log)","Evaluative") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2) 
foreach x in indu judges attyfirms fafirms {
reg lnfafeeexpord1 lnrolefa1  $`x' [pw=pweight] if roledipfa>0, vce(robust)
test $`x'
	}
reg lnfafeeexpord1  lnassets lnsales yearconfirmed blackstone  houlihan  lnrolefa1 [pw=pweight] if roledipfa>0, vce(robust)
outreg2 using table6_10.rtf, append  ///
	label  ctitle ("FaFee-","ExpOrd","(log)","Evaluative") alpha(0.001, 0.01, 0.05, 0.10) symbol(***, **, *, +) adjr2 bdec(3) rdec(2) 
	


log close
